/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Menu;
import age.of.civilizations2.jakowski.lukasz.MessageCategory;
import age.of.civilizations2.jakowski.lukasz.MessageHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.Executor;

public class M_P2P {
    private static Socket socket;
    private static InputStream in;
    private static OutputStream out;
    private static UUID uid;
    private static volatile boolean isConnected;
    private static Executor uiThreadExecutor;

    public static void setUIThreadExecutor(Executor executor) {
        uiThreadExecutor = executor;
    }

    private static void runOnUIThread(Runnable task) {
        if (uiThreadExecutor != null) {
            uiThreadExecutor.execute(task);
        } else {
            task.run();
        }
    }

    private static byte[] readFully(InputStream in, int length) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[length];
        for (int totalBytesRead = 0; totalBytesRead < length; totalBytesRead += bytesRead) {
            bytesRead = in.read(buffer, totalBytesRead, length - totalBytesRead);
            if (bytesRead != -1) continue;
            throw new IOException("Ba\u011flant\u0131 beklenmedik \u015fekilde kapand\u0131.");
        }
        return buffer;
    }

    public static void connect(String ip, int port, ConnectionCallback callback) {
        if (isConnected) {
            M_P2P.runOnUIThread(() -> callback.onFailure("Zaten bir ba\u011flant\u0131 var."));
            return;
        }
        new Thread(() -> {
            try {
                socket = new Socket(ip, port);
                in = socket.getInputStream();
                out = socket.getOutputStream();
                byte[] lengthBytes = M_P2P.readFully(in, 4);
                int length = ByteBuffer.wrap(lengthBytes).getInt();
                if (length != 16) {
                    throw new IOException("Ge\u00e7ersiz UID uzunlu\u011fu: " + length);
                }
                byte[] uidBytes = M_P2P.readFully(in, length);
                ByteBuffer bb = ByteBuffer.wrap(uidBytes);
                long most = bb.getLong();
                long least = bb.getLong();
                uid = new UUID(most, least);
                isConnected = true;
                M_P2P.runOnUIThread(callback::onSuccess);
                M_P2P.listenForMessages();
            }
            catch (IOException e) {
                isConnected = false;
                M_P2P.runOnUIThread(() -> callback.onFailure("Ba\u011flant\u0131 kurulamad\u0131: " + e.getMessage()));
            }
        }).start();
    }

    public static void connectAsync(final String ip, final int port) {
        M_P2P.connect(ip, port, new ConnectionCallback(){

            @Override
            public void onSuccess() {
                System.out.println("Ba\u011flant\u0131 ba\u015far\u0131yla kuruldu: " + ip + ":" + port);
            }

            @Override
            public void onFailure(String errorMessage) {
                System.out.println("Ba\u011flant\u0131 hatas\u0131: " + errorMessage);
            }
        });
    }

    public static void disconnect() {
        isConnected = false;
        try {
            if (socket != null && !socket.isClosed()) {
                socket.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            socket = null;
            in = null;
            out = null;
        }
    }

    public static UUID getUid() {
        return uid;
    }

    public static boolean isConnected() {
        return isConnected;
    }

    public static void sendMessage(MessageCategory category, byte[] content) {
        if (!isConnected || out == null) {
            M_P2P.handleConnectionError("Sunucuya mesaj g\u00f6nderilemedi: Ba\u011flant\u0131 yok.");
            return;
        }
        try {
            byte[] uidBytes = new byte[16];
            ByteBuffer.wrap(uidBytes).putLong(uid.getMostSignificantBits()).putLong(uid.getLeastSignificantBits());
            ByteBuffer buffer = ByteBuffer.allocate(24 + content.length);
            buffer.putInt(20 + content.length);
            buffer.put(uidBytes);
            buffer.putInt(category.ordinal());
            buffer.put(content);
            out.write(buffer.array());
            out.flush();
        }
        catch (IOException e) {
            M_P2P.handleConnectionError("Sunucuya mesaj g\u00f6nderilemedi: " + e.getMessage());
        }
    }

    private static void listenForMessages() {
        new Thread(() -> {
            try {
                while (isConnected && socket != null && !socket.isClosed()) {
                    long least;
                    long most;
                    ByteBuffer bb;
                    byte[] lengthBytes = M_P2P.readFully(in, 4);
                    int length = ByteBuffer.wrap(lengthBytes).getInt();
                    if (length <= 0) continue;
                    byte[] msgBytes = M_P2P.readFully(in, length);
                    if (length == 16) {
                        bb = ByteBuffer.wrap(msgBytes);
                        most = bb.getLong();
                        least = bb.getLong();
                        uid = new UUID(most, least);
                        continue;
                    }
                    bb = ByteBuffer.wrap(msgBytes);
                    most = bb.getLong();
                    least = bb.getLong();
                    UUID msgUid = new UUID(most, least);
                    int categoryOrdinal = bb.getInt();
                    byte[] content = new byte[msgBytes.length - 16 - 4];
                    bb.get(content);
                    MessageCategory category = MessageCategory.values()[categoryOrdinal];
                    M_P2P.runOnUIThread(() -> MessageHandler.handle(category, msgUid, content));
                }
            }
            catch (IOException e) {
                if (isConnected) {
                    M_P2P.handleConnectionError("Sunucuyla ba\u011flant\u0131 koptu: " + e.getMessage());
                }
            }
            finally {
                M_P2P.disconnect();
            }
        }).start();
    }

    private static void handleConnectionError(String message) {
        M_P2P.disconnect();
        M_P2P.runOnUIThread(() -> {
            CFG.menuManager.setViewID(Menu.eMAINMENU);
            CFG.toast.setInView(message, CFG.COLOR_TEXT_MODIFIER_NEGATIVE2);
            CFG.toast.setTimeInView(4000);
        });
    }

    static {
        isConnected = false;
    }

    public static interface ConnectionCallback {
        public void onSuccess();

        public void onFailure(String var1);
    }
}

