/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class HolyRomanEmpire_GameData
implements Serializable {
    private static final long serialVersionUID = 0L;
    private List<Integer> lProvinces = new ArrayList<Integer>();
    private int iProvincesSize = 0;
    private int iEmperorID = -1;
    private int iEmperorAuthority = 0;
    private List<Integer> lElectors = new ArrayList<Integer>();
    private int iElectorsSize = 0;
    private List<Integer> lPrinces = new ArrayList<Integer>();
    private int iPrincesSize = 0;
    protected List<Integer> lVotesFor = new ArrayList<Integer>();
    private int iNextElectionsIn = 30;

    protected final void updateHRE_AfterRemoveCivilization(int nCivID) {
        for (int i = 0; i < this.getPrincesSize(); ++i) {
            if (this.getPrince(i) == nCivID) {
                this.removePrince(nCivID);
                --i;
                continue;
            }
            if (this.getPrince(i) <= nCivID) continue;
            this.lPrinces.set(i, this.lPrinces.get(i) - 1);
        }
    }

    protected final int getProvinces(int i) {
        return this.lProvinces.get(i);
    }

    protected final boolean addProvince(int nProvinceID) {
        for (int i = 0; i < this.getProvincesSize(); ++i) {
            if (this.getProvinces(i) != nProvinceID) continue;
            return false;
        }
        this.lProvinces.add(nProvinceID);
        this.iProvincesSize = this.lProvinces.size();
        CFG.game.getProvince(nProvinceID).setIsPartOfHolyRomanEmpire(true);
        return true;
    }

    protected final boolean removeProvince(int nProvinceID) {
        for (int i = 0; i < this.getProvincesSize(); ++i) {
            if (this.getProvinces(i) != nProvinceID) continue;
            CFG.game.getProvince(nProvinceID).setIsPartOfHolyRomanEmpire(false);
            this.lProvinces.remove(i);
            this.iProvincesSize = this.lProvinces.size();
            return true;
        }
        return false;
    }

    protected final int getProvincesSize() {
        return this.iProvincesSize;
    }

    protected final boolean getIsImperialProvince(int nProvinceID) {
        for (int i = 0; i < this.getPrincesSize(); ++i) {
            if (this.getProvinces(i) != nProvinceID) continue;
            return true;
        }
        return false;
    }

    protected final int getPrince(int i) {
        return this.lPrinces.get(i);
    }

    protected final void addPrince(int nCivID) {
        for (int i = 0; i < this.getPrincesSize(); ++i) {
            if (this.getPrince(i) != nCivID) continue;
            return;
        }
        this.lPrinces.add(nCivID);
        this.iPrincesSize = this.lPrinces.size();
        CFG.game.getCiv(nCivID).setIsPartOfHolyRomanEmpire(true);
    }

    protected final void removePrinceID(int nID) {
        this.removePrince(this.getPrince(nID));
    }

    protected final void removePrince(int nCivID) {
        for (int i = 0; i < this.getPrincesSize(); ++i) {
            if (this.getPrince(i) != nCivID) continue;
            CFG.game.getCiv(nCivID).setIsPartOfHolyRomanEmpire(false);
            this.removeElector(nCivID);
            this.lPrinces.remove(i);
            this.iPrincesSize = this.lPrinces.size();
            for (int j = 0; j < this.getElectorsSize(); ++j) {
                if (this.lElectors.get(j) <= i) continue;
                this.lElectors.set(j, this.lElectors.get(j) - 1);
            }
            if (this.iEmperorID == i) {
                this.iEmperorID = this.getElectorsSize() > 0 ? this.getElector(0) : -1;
            } else if (this.iEmperorID > i) {
                --this.iEmperorID;
            }
            return;
        }
    }

    protected final int getPrincesSize() {
        return this.iPrincesSize;
    }

    protected final int getPrincesSize_True() {
        int out = 0;
        for (int i = 0; i < this.getPrincesSize(); ++i) {
            if (CFG.game.getCiv(this.getPrince(i)).getNumOfProvinces() <= 0) continue;
            ++out;
        }
        return out;
    }

    protected final boolean getIsPrince(int nCivID) {
        for (int i = 0; i < this.getPrincesSize(); ++i) {
            if (this.getPrince(i) != nCivID) continue;
            return true;
        }
        return false;
    }

    protected final int getEmperor() {
        return this.lPrinces.get(this.iEmperorID);
    }

    protected final void setEmperor(int nCivID) {
        for (int i = 0; i < this.getPrincesSize(); ++i) {
            if (this.getPrince(i) != nCivID) continue;
            this.iEmperorID = i;
            this.removeElector(nCivID);
            return;
        }
    }

    protected final void setEmperorID(int nID) {
        this.iEmperorID = this.iEmperorID == nID || nID >= this.getPrincesSize() ? -1 : nID;
    }

    protected final int getEmperorAuthority() {
        return this.iEmperorAuthority;
    }

    protected final void setEmperorAuthority(int iEmperorAuthority) {
        this.iEmperorAuthority = iEmperorAuthority;
    }

    protected boolean getIsEmperor(int nCivID) {
        return this.iEmperorID >= 0 && this.getPrince(this.iEmperorID) == nCivID;
    }

    protected final int getElector(int i) {
        return this.lElectors.get(i);
    }

    protected final void addElector(int nCivID) {
        if (this.getElectorsSize() < 7) {
            for (int i = 0; i < this.getPrincesSize(); ++i) {
                if (this.getPrince(i) != nCivID) continue;
                this.lElectors.add(i);
                this.iElectorsSize = this.lElectors.size();
                this.buildVotesFor();
                return;
            }
        }
    }

    protected final void removeElector(int nCivID) {
        for (int i = 0; i < this.getElectorsSize(); ++i) {
            if (this.getPrince(this.lElectors.get(i)) != nCivID) continue;
            this.lElectors.remove(i);
            this.iElectorsSize = this.lElectors.size();
            this.buildVotesFor();
            return;
        }
    }

    protected final int getElectorsSize() {
        return this.iElectorsSize;
    }

    protected final boolean getIsElector(int nCivID) {
        for (int i = 0; i < this.getElectorsSize(); ++i) {
            if (this.getPrince(this.getElector(i)) != nCivID) continue;
            return true;
        }
        return false;
    }

    protected final void setElectorID(int nID) {
        if (nID < this.getPrincesSize()) {
            if (this.getIsElector(this.getPrince(nID))) {
                this.removeElector(this.getPrince(nID));
            } else {
                this.addElector(this.getPrince(nID));
            }
        }
    }

    protected final void addStrongestPrinceAsElector() {
        ArrayList<Integer> tPossibleElectors = new ArrayList<Integer>();
        for (int i = 0; i < this.getPrincesSize(); ++i) {
            if (CFG.game.getCiv(this.getPrince(i)).getNumOfProvinces() <= 0 || this.getIsElector(this.getPrince(i)) || this.getIsEmperor(this.getPrince(i))) continue;
            tPossibleElectors.add(this.getPrince(i));
        }
        if (tPossibleElectors.size() > 0) {
            int tBest = 0;
            for (int j = 0; j < tPossibleElectors.size(); ++j) {
                if (CFG.game.getCiv((Integer)tPossibleElectors.get(j)).countPopulation() <= CFG.game.getCiv((Integer)tPossibleElectors.get(tBest)).countPopulation()) continue;
                tBest = j;
            }
            this.addElector((Integer)tPossibleElectors.get(tBest));
        }
    }

    protected final void buildVotesFor() {
        if (this.lVotesFor == null) {
            this.lVotesFor = new ArrayList<Integer>();
        }
        if (this.lVotesFor.size() == 0) {
            for (int i = 0; i < this.getElectorsSize(); ++i) {
                this.lVotesFor.add(this.getPrince(this.getElector(i)));
            }
        } else {
            int j;
            ArrayList<Integer> oldVotes = new ArrayList<Integer>();
            for (j = 0; j < this.lVotesFor.size(); ++j) {
                oldVotes.add(this.lVotesFor.get(j));
            }
            this.lVotesFor.clear();
            for (j = 0; j < this.getElectorsSize(); ++j) {
                if (CFG.game.getCiv(this.getPrince(this.getElector(j))).getControlledByPlayer()) {
                    try {
                        this.lVotesFor.add((Integer)oldVotes.get(j));
                    }
                    catch (IndexOutOfBoundsException ex) {
                        this.lVotesFor.add(this.getPrince(this.getElector(j)));
                    }
                    continue;
                }
                this.lVotesFor.add(this.getPrince(this.getElector(j)));
            }
        }
    }

    protected final int getNextElectionsIn() {
        return this.iNextElectionsIn;
    }

    protected final void setNextElectionsIn(int iNextElectionsIn) {
        this.iNextElectionsIn = iNextElectionsIn;
    }

    protected final void randomNextElections() {
        this.iNextElectionsIn = 32 + CFG.oR.nextInt(60);
    }
}

