/*
 * Decompiled with CFR 0.152.
 */
package com.codedisaster.steamworks;

import com.codedisaster.steamworks.SteamAPICall;
import com.codedisaster.steamworks.SteamGameServerAPINative;
import com.codedisaster.steamworks.SteamGameServerStatsCallback;
import com.codedisaster.steamworks.SteamGameServerStatsCallbackAdapter;
import com.codedisaster.steamworks.SteamGameServerStatsNative;
import com.codedisaster.steamworks.SteamID;
import com.codedisaster.steamworks.SteamInterface;

public class SteamGameServerStats
extends SteamInterface {
    public SteamGameServerStats(SteamGameServerStatsCallback callback) {
        super(SteamGameServerAPINative.getSteamGameServerStatsPointer(), SteamGameServerStatsNative.createCallback(new SteamGameServerStatsCallbackAdapter(callback)));
    }

    public SteamAPICall requestUserStats(SteamID steamIDUser) {
        return new SteamAPICall(SteamGameServerStatsNative.requestUserStats(this.pointer, steamIDUser.handle));
    }

    public int getUserStatI(SteamID steamIDUser, String name, int defaultValue) {
        int[] values = new int[1];
        if (SteamGameServerStatsNative.getUserStat(this.pointer, steamIDUser.handle, name, values)) {
            return values[0];
        }
        return defaultValue;
    }

    public float getUserStatF(SteamID steamIDUser, String name, float defaultValue) {
        float[] values = new float[1];
        if (SteamGameServerStatsNative.getUserStat(this.pointer, steamIDUser.handle, name, values)) {
            return values[0];
        }
        return defaultValue;
    }

    public boolean getUserAchievement(SteamID steamIDUser, String name, boolean defaultValue) {
        boolean[] achieved = new boolean[1];
        if (SteamGameServerStatsNative.getUserAchievement(this.pointer, steamIDUser.handle, name, achieved)) {
            return achieved[0];
        }
        return defaultValue;
    }

    public boolean setUserStatI(SteamID steamIDUser, String name, int value) {
        return SteamGameServerStatsNative.setUserStat(this.pointer, steamIDUser.handle, name, value);
    }

    public boolean setUserStatF(SteamID steamIDUser, String name, float value) {
        return SteamGameServerStatsNative.setUserStat(this.pointer, steamIDUser.handle, name, value);
    }

    public boolean updateUserAvgRateStat(SteamID steamIDUser, String name, float countThisSession, double sessionLength) {
        return SteamGameServerStatsNative.updateUserAvgRateStat(this.pointer, steamIDUser.handle, name, countThisSession, sessionLength);
    }

    public boolean setUserAchievement(SteamID steamIDUser, String name) {
        return SteamGameServerStatsNative.setUserAchievement(this.pointer, steamIDUser.handle, name);
    }

    public boolean clearUserAchievement(SteamID steamIDUser, String name) {
        return SteamGameServerStatsNative.clearUserAchievement(this.pointer, steamIDUser.handle, name);
    }

    public SteamAPICall storeUserStats(SteamID steamIDUser) {
        return new SteamAPICall(SteamGameServerStatsNative.storeUserStats(this.pointer, steamIDUser.handle));
    }
}

