/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Graph;
import age.of.civilizations2.jakowski.lukasz.GraphLine;
import age.of.civilizations2.jakowski.lukasz.ImageManager;
import age.of.civilizations2.jakowski.lukasz.Images;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.utils.ScissorStack;
import java.util.ArrayList;
import java.util.List;

class GraphData {
    private static final float ALPHA_CIV_LINE = 0.8f;
    protected static final int ANIMATION_TIME = 750;
    private boolean backAnimation = false;
    private boolean drawData = true;
    private int iBeginTurnID;
    private int iCivID;
    private int iPointsSize = 0;
    private List<GraphLine> lGraphLines;
    private List<Integer> lPointsY;
    private long lTime = 0L;
    private boolean visible = true;

    protected GraphData(int n, List<Integer> list, int n2) {
        this.iCivID = n;
        this.iPointsSize = list.size();
        this.lPointsY = new ArrayList<Integer>();
        this.lGraphLines = new ArrayList<GraphLine>();
        for (n = 0; n < this.iPointsSize; ++n) {
            this.lPointsY.add(list.get(n));
        }
        this.iBeginTurnID = n2;
        this.drawData = false;
    }

    private final void drawGraphData(SpriteBatch spriteBatch, int n, int n2, List<Integer> list, int n3, boolean bl) {
        float f = 1.0f;
        float f2 = (float)CFG.game.getCiv(this.iCivID).getR() / 255.0f;
        float f3 = (float)CFG.game.getCiv(this.iCivID).getG() / 255.0f;
        float f4 = (float)CFG.game.getCiv(this.iCivID).getB() / 255.0f;
        float f5 = bl ? 1.0f : 0.8f;
        try {
            Color color2 = new Color(f2, f3, f4, f5);
            spriteBatch.setColor(color2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            f5 = bl ? f : 0.8f;
            spriteBatch.setColor(new Color(0.05882353f, 0.05882353f, 0.05882353f, f5));
        }
        for (int i = 0; i < this.iPointsSize - 1; ++i) {
            this.lGraphLines.get(i).draw(spriteBatch, list.get(this.iBeginTurnID + i) + n, n2, n3);
        }
    }

    protected final void buildGraph(int n, int n2, int n3, List<Integer> list) {
        this.lGraphLines.clear();
        int n4 = 0;
        while (n4 < this.iPointsSize - 1) {
            List<GraphLine> list2 = this.lGraphLines;
            int n5 = list.get(this.iBeginTurnID + n4);
            float f = n;
            float f2 = this.lPointsY.get(n4).intValue();
            float f3 = n3 - n2;
            int n6 = (int)(f - f2 * 100.0f * f / f3 / 100.0f);
            int n7 = list.get(this.iBeginTurnID + n4 + 1);
            List<Integer> list3 = this.lPointsY;
            list2.add(new GraphLine(n5, n6, n7, (int)(f - (float)list3.get(++n4).intValue() * 100.0f * f / f3 / 100.0f)));
        }
    }

    protected final void draw(SpriteBatch spriteBatch, int n, int n2, int n3, int n4, List<Integer> list, int n5, boolean bl, int n6) {
        if (this.lTime + 750L >= System.currentTimeMillis()) {
            this.drawAnimation(spriteBatch, n, n2, n3, n4, list, n5, bl, n6);
        } else {
            this.drawGraphData(spriteBatch, n, n2 - n6, list, n5, bl);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void drawAnimation(SpriteBatch spriteBatch, int n, int n2, int n3, int n4, List<Integer> list, int n5, boolean bl, int n6) {
        Rectangle rectangle = this.backAnimation ? new Rectangle(n, CFG.GAME_HEIGHT - n2, n3 - (int)((float)n3 * ((float)(System.currentTimeMillis() - this.lTime) / 750.0f)), -n4) : new Rectangle(n, CFG.GAME_HEIGHT - n2, (int)((float)n3 * ((float)(System.currentTimeMillis() - this.lTime) / 750.0f)), -n4);
        spriteBatch.flush();
        ScissorStack.pushScissors(rectangle);
        this.drawGraphData(spriteBatch, n, n2 - n6, list, n5, true);
        CFG.setRender_3(true);
        try {
            spriteBatch.flush();
            ScissorStack.popScissors();
            return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    protected final void drawCivButton(SpriteBatch spriteBatch, int n, int n2, boolean bl) {
        Color color2;
        float f = Graph.GRAPH_BG_COLOR.r;
        float f2 = Graph.GRAPH_BG_COLOR.g;
        float f3 = Graph.GRAPH_BG_COLOR.b;
        float f4 = bl ? Graph.GRAPH_BG_COLOR.a * 2.0f : (this.drawData ? Graph.GRAPH_BG_COLOR.a : Graph.GRAPH_BG_COLOR.a / 4.0f);
        spriteBatch.setColor(new Color(f, f2, f3, f4));
        ImageManager.getImage(Images.pix255_255_255).draw(spriteBatch, n, n2, Graph.getGraphButtonWidth(), Graph.getGraphButtonHeight());
        f3 = Graph.GRAPH_BORDERS_COLOR.r;
        f2 = Graph.GRAPH_BORDERS_COLOR.g;
        f = Graph.GRAPH_BORDERS_COLOR.b;
        f4 = this.drawData ? Graph.GRAPH_BORDERS_COLOR.a : 0.25f;
        spriteBatch.setColor(new Color(f3, f2, f, f4));
        f3 = 0.8f;
        float f5 = (float)CFG.game.getCiv(this.iCivID).getR() / 255.0f;
        f2 = (float)CFG.game.getCiv(this.iCivID).getG() / 255.0f;
        f = (float)CFG.game.getCiv(this.iCivID).getB() / 255.0f;
        f4 = this.drawData ? 0.8f : 0.4f;
        try {
            color2 = new Color(f5, f2, f, f4);
            spriteBatch.setColor(color2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            f4 = this.drawData ? f3 : 0.4f;
            spriteBatch.setColor(new Color(0.05882353f, 0.05882353f, 0.05882353f, f4));
        }
        ImageManager.getImage(Images.pix255_255_255).draw(spriteBatch, n, n2, CFG.CIV_COLOR_WIDTH, Graph.getGraphButtonHeight());
        color2 = this.drawData ? Color.WHITE : new Color(1.0f, 1.0f, 1.0f, 0.25f);
        spriteBatch.setColor(color2);
        try {
            CFG.game.getCiv(this.iCivID).getFlag().draw(spriteBatch, Graph.getGraphButtonWidth() / 2 + n - CFG.CIV_FLAG_WIDTH / 2, Graph.getGraphButtonHeight() / 2 + n2 - CFG.CIV_FLAG_HEIGHT / 2 - CFG.game.getCiv(this.iCivID).getFlag().getHeight(), CFG.CIV_FLAG_WIDTH, CFG.CIV_FLAG_HEIGHT);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ImageManager.getImage(Images.randomCivilizationFlag).draw(spriteBatch, Graph.getGraphButtonWidth() / 2 + n - CFG.CIV_FLAG_WIDTH / 2, Graph.getGraphButtonHeight() / 2 + n2 - CFG.CIV_FLAG_HEIGHT / 2 - ImageManager.getImage(Images.randomCivilizationFlag).getHeight(), CFG.CIV_FLAG_WIDTH, CFG.CIV_FLAG_HEIGHT);
        }
        ImageManager.getImage(Images.flag_rect).draw(spriteBatch, n + Graph.getGraphButtonWidth() / 2 - CFG.CIV_FLAG_WIDTH / 2, n2 + Graph.getGraphButtonHeight() / 2 - CFG.CIV_FLAG_HEIGHT / 2);
        spriteBatch.setColor(Color.WHITE);
    }

    protected final boolean getBackAnimation() {
        return this.backAnimation;
    }

    protected final int getBeginTurnID() {
        return this.iBeginTurnID;
    }

    protected final int getCivID() {
        return this.iCivID;
    }

    protected final boolean getDrawData() {
        return this.drawData;
    }

    protected final int getPointY(int n) {
        try {
            n = this.lPointsY.get(n);
            return n;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return 0;
        }
    }

    protected final int getPointsSize() {
        return this.iPointsSize;
    }

    protected final long getTime() {
        return this.lTime;
    }

    protected final boolean getVisible() {
        return this.visible;
    }

    protected final void setBackAnimation(boolean bl) {
        this.backAnimation = bl;
    }

    protected final void setDrawData(boolean bl) {
        if (bl != this.drawData) {
            this.lTime = this.lTime > System.currentTimeMillis() - 750L && (this.drawData || this.backAnimation) ? System.currentTimeMillis() - (750L - (System.currentTimeMillis() - this.lTime)) : System.currentTimeMillis();
            CFG.setRender_3(true);
            this.backAnimation = bl ^ true;
        }
        this.drawData = bl;
    }

    protected final void setVisible(boolean bl) {
        this.visible = bl;
    }
}

